CREATE FUNCTION [dbo].[CFJ_Producto_Fechas](@pJson VARCHAR(2048))
RETURNS VARCHAR(2048)
AS
BEGIN


/*Variables recibidas por parámetro a traves del JSON*/
DECLARE @pFlagUsarTrans			TINYINT
DECLARE @pModoDebug				TINYINT
DECLARE @pId_Producto			VARCHAR(14)
DECLARE @pFecha					DATETIME

SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Producto				= ISNULL(CONVERT(VARCHAR(14), dbo.CF_JSON_VALUE(@pJson,'Id_Producto')), '')
SET @pFecha						= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha')), '19000101')
/*FIN Variables recibidas por parámetro a traves del JSON*/

/*Variable de Retorno del Stored*/
DECLARE @rtaErrorStored						INT
DECLARE @rtaMsjStored						VARCHAR(4000)
declare @JSON varchar(2000)
DECLARE @Retorno VARCHAR(2048)
/*FIN Variable de Retorono del Stored*/

/*Variables Locales*/
DECLARE @Flag_Mes				INT 
DECLARE @Flag_Periodo			INT 
DECLARE @Flag_Periodo_Tipo		CHAR(1) 
DECLARE @Flag_Periodo_Hasta		DATETIME
DECLARE @Flag_Periodo_Desde		DATETIME
DECLARE @Flag_Periodo_Cant		SMALLINT

DECLARE @Fecha_Desde			DATE
DECLARE @Fecha_Hasta			DATE
/*FIN Variables Locales*/

/*=================================================================================*/
	/*
	 * PRIORIDADES:
	 * 
	 * 1) Flag Mes
	 * 2) Flag Periodo
	*/


	SELECT	@Flag_Mes			= Flag_Mes,
			@Flag_Periodo		= Flag_Periodo ,
			@Flag_Periodo_Tipo	= Flag_Periodo_Tipo,
			@Flag_Periodo_Hasta	= Flag_Periodo_Hasta,
			@Flag_Periodo_Desde = Flag_Periodo_Desde,
			@Flag_Periodo_Cant	= Flag_Periodo_Cant
	FROM Productos 
	WHERE Id_Producto=@pId_Producto

	/*=================================================================================*/
		SET @Fecha_Desde = CONVERT(DATE,GETDATE())
		SET @Fecha_Hasta = '19000101'

	IF (@Flag_Mes=1)
	BEGIN
		SET @Fecha_Hasta = DATEADD(month, 1, @Fecha_Desde)
	END 

	IF (@Flag_Periodo=1)
	BEGIN
		IF (@Flag_Periodo_Cant>=1)
		BEGIN
			IF(@Flag_Periodo_Tipo='D')
			BEGIN
				SET @Fecha_Hasta = DATEADD(day, @Flag_Periodo_Cant, @Fecha_Desde)
			END 

			IF(@Flag_Periodo_Tipo='M')
			BEGIN
				SET @Fecha_Hasta = DATEADD(MONTH, @Flag_Periodo_Cant, @Fecha_Desde)
			END 

			IF(@Flag_Periodo_Tipo='A')
			BEGIN
				SET @Fecha_Hasta = DATEADD(YEAR, @Flag_Periodo_Cant, @Fecha_Desde)
			END 

			IF(@Flag_Periodo_Tipo='F')
			BEGIN
				SET @Fecha_Desde = @Flag_Periodo_Desde
				SET @Fecha_Hasta = @Flag_Periodo_Hasta
			END 

		END 
	END 



	/*=================================================================================*/

SET @Retorno 		=	'{' +
								dbo.CF_Json_ParsearVariable('Id_Producto', @pId_Producto, 'VARCHAR(14)') + ',' + 
								dbo.CF_Json_ParsearVariable('Fecha_Desde', @Fecha_Desde, 'DATE') + ',' + 
								dbo.CF_Json_ParsearVariable('Fecha_Hasta', @Fecha_Hasta, 'DATE') + 
								'}'

RETURN @Retorno


END


